﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Edu.Library.Collections
{
    public class EsyList<T> : IEnumerable<T>
    {
        private List<T> _list;

        public EsyList() { _list = new List<T>(); }

        public EsyList(IEnumerable<T> values)
        {
            _list = values.ToList();
        }

        public IEnumerator<T> GetEnumerator()
        {
            return _list.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _list.GetEnumerator();
        }

        public void Add(T item) { _list.Add(item); }
        public void RemoveAt(int index) { _list.RemoveAt(index); }
        public void Clear() { _list.Clear(); }
        public int Count { get { return _list.Count; } }

        public T this[int index]
        {
            get { return _list[index - 1]; }
            set { _list[index - 1] = value; }
        }
    }
}
